package nemosofts.voxradio.activity;

import android.app.Dialog;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;
import android.widget.SeekBar;
import android.widget.TextView;

import androidx.appcompat.widget.Toolbar;
import androidx.nemosofts.AppCompat;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.view.SwitchButton;
import androidx.viewpager.widget.ViewPager;

import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.adapter.NowPlayingScreenAdapter;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.IfSupported;
import nemosofts.voxradio.utils.NowPlayingScreen;
import nemosofts.voxradio.utils.SharedPref;

public class SettingNowPlayingActivity extends AppCompatActivity {

    private SharedPref sharedPref;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IfSupported.IsRTL(this);
        IfSupported.IsScreenshot(this);

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        toolbar.setTitle(getResources().getString(R.string.settings));
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
            toolbar.setNavigationOnClickListener(view -> onBackPressed());
        }

        sharedPref = new SharedPref(this);

        SwitchButton switch_volume = findViewById(R.id.switch_volume);
        switch_volume.setChecked(sharedPref.isVolume());
        switch_volume.setOnCheckedChangeListener((view, isChecked) -> sharedPref.setVolume(isChecked));

        SwitchButton switch_snow_fall = findViewById(R.id.switch_snow_fall);
        switch_snow_fall.setChecked(sharedPref.isSnowFall());
        switch_snow_fall.setOnCheckedChangeListener((view, isChecked) -> sharedPref.setSnowFall(isChecked));

        findViewById(R.id.ll_now_playing).setOnClickListener(view -> openNowPlaying());

        TextView tv_blur = findViewById(R.id.tv_blur_now);
        SeekBar sb_blur = findViewById(R.id.sb_blur_now);
        sb_blur.setMax(80);
        sb_blur.setProgress(sharedPref.getBlurAmount());
        tv_blur.setText(String.valueOf(sharedPref.getBlurAmount()));
        sb_blur.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                tv_blur.setText(String.valueOf(progress));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int progress = seekBar.getProgress();
                sharedPref.setBlurAmount(progress);
                tv_blur.setText(String.valueOf(progress));
            }
        });
    }

    private void openNowPlaying() {
        final Dialog dialog_rate;
        final int[] viewPagerPosition = new int[1];
        dialog_rate = new Dialog(SettingNowPlayingActivity.this);
        dialog_rate.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog_rate.setContentView(R.layout.dialog_now_playing_screen);

        final ViewPager viewPager = dialog_rate.findViewById(R.id.now_playing_screen_view_pager);
        viewPager.setAdapter(new NowPlayingScreenAdapter(this));
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                viewPagerPosition[0] = position;
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        viewPager.setPageMargin((int) ApplicationUtil.convertDpToPixel(32, getResources()));
        viewPager.setCurrentItem(sharedPref.getNowPlayingScreen().ordinal());

        dialog_rate.findViewById(R.id.tv_submit_btn).setOnClickListener(view -> {
            NowPlayingScreen nowPlayingScreen = NowPlayingScreen.values()[viewPagerPosition[0]];
            sharedPref.setNowPlayingScreen(nowPlayingScreen);
            dialog_rate.dismiss();
            Callback.nowPlayingScreen = sharedPref.getNowPlayingScreen().ordinal();
        });

        dialog_rate.findViewById(R.id.tv_cancel_btn).setOnClickListener(view -> dialog_rate.dismiss());
        Objects.requireNonNull(dialog_rate.getWindow()).setBackgroundDrawableResource(android.R.color.transparent);
        dialog_rate.show();
        Window window = dialog_rate.getWindow();
        window.setLayout(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT);
    }

    @Override
    public int setLayoutResourceId() {
        return R.layout.activity_setting_now_playing;
    }

    @Override
    public int setAppCompat() {
        return AppCompat.COMPAT();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}